<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <div class="content">
        <div class="container-fluid">
            <div class="card no-print">
                <div class="card-body">
                    <form action="/relatorios/porVendedor" method="post">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="">Vendedor</label>
                                    <select class="form-control select2" name="id_vendedor" style="width: 100%" required>
                                        <?php foreach($vendedores as $vendedor): ?>
                                            <?php if($vendedor['id_vendedor'] == $id_vendedor): ?>
                                                <option value="<?= $vendedor['id_vendedor'] ?>" selected><?= $vendedor['nome'] ?></option>
                                            <?php else: ?>
                                                <option value="<?= $vendedor['id_vendedor'] ?>"><?= $vendedor['nome'] ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <button type="submit" class="btn btn-success" style="margin-top: 30px">Gerar Relatório</button>
                                <button type="button" class="btn btn-info" onclick="print()" style="margin-top: 30px"><i class="fas fa-print"></i> Imprimir / Salvar PDF</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.card -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="row" style="margin-top: 30px">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <p style="text-align: center"><b><?= $empresa['xNome'] ?></b></p>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                                    <p>
                                        <b>CNPJ:</b> <span class="cnpj"><?= $empresa['CNPJ'] ?></span> <br>
                                        <b>CONTATO:</b> <span class="celular"><?= $empresa['fone'] ?></span> <br>
                                        <b>ENDEREÇO:</b> <?= $empresa['xLgr'] ?>, <?= $empresa['nro'] ?>, <?= $empresa['xCpl'] ?>, <?= $empresa['xBairro'] ?>.
                                    </p>
                                </div>
                            </div>
                            <div class="row" style="margin-top: 30px">
                                <div class="col-lg-12">
                                    <h6 class="m-0 text-dark" style="text-align: center"><b><?= $titulo['modulo'] ?></b></h6>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="card-body table-responsive p-0">
                                        <table class="table table-hover text-nowrap table-bordered table-striped">
                                            <thead>
                                                <tr style="border-top: 1px solid lightgrey">
                                                    <th>Cód.</th>
                                                    <th>Data</th>
                                                    <th>Hora</th>
                                                    <th>Valor</th>
                                                    <th>Cliente</th>
                                                    <th>Cód. Caixa</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if(!empty($vendas)): ?>
                                                    <?php foreach($vendas as $venda): ?>
                                                        <tr>
                                                            <td><?= $venda['id_venda'] ?></td>
                                                            <td><?= date('d/m/Y', strtotime($venda['data'])) ?></td>
                                                            <td><?= $venda['hora'] ?></td>
                                                            <td><?= number_format($venda['valor_a_pagar'], 2, ',', '.') ?></td>
                                                            <td><?= $venda['nome_do_cliente'] ?></td>
                                                            <td><?= $venda['id_caixa'] ?></td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td colspan="6">Nenhum registro!</td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12">
                                    <p>Relatório gerado em: <?= date('d/m/Y') ?> às <?= date('H:i') ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->